<?php
$pageTitle = "Daftar Akun Baru | Arab Academy";
// Mulai sesi
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Jika sudah login, alihkan ke beranda (tidak perlu daftar lagi)
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    header('Location: index.php');
    exit;
}

// -------------------------------------------------------------
// *SOLUSI CSS: Asumsi includes/header.php hanya berisi <head> dan <body>*
// Kita akan membuat koneksi CSS di sini jika tidak ada di header.php
// Jika style.css berada di folder yang sama dengan registrasi.php:
echo '<link rel="stylesheet" href="assets/css/style.css">';
// JIKA style.css berada di folder "css", ganti baris di atas menjadi:
// echo '<link rel="stylesheet" href="css/style.css">';
// -------------------------------------------------------------

include 'includes/header.php'; // Memuat sisa header (jika ada) dan membuka <body>

$success_message = '';
$error_message = '';
$full_name = '';
$username = '';
$email = '';

// --- PROSES PENDAFTARAN ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include 'includes/db_config.php'; // Hubungkan ke database
    
    // Ambil dan bersihkan data
    $full_name = trim($_POST['full_name'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    // Validasi Sisi Server
    if (empty($full_name) || empty($username) || empty($email) || empty($password) || empty($confirm_password)) {
        $error_message = 'Semua kolom wajib diisi.';
    } elseif ($password !== $confirm_password) {
        $error_message = 'Konfirmasi kata sandi tidak cocok.';
    } elseif (strlen($password) < 6) {
        $error_message = 'Kata sandi minimal 6 karakter.';
    } else {
        // Enkripsi Password
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
        
        // Cek apakah username atau email sudah terdaftar
        $stmt_check = $conn->prepare("SELECT user_id FROM users WHERE username = ? OR email = ?");
        $stmt_check->bind_param("ss", $username, $email);
        $stmt_check->execute();
        $stmt_check->store_result();
        
        if ($stmt_check->num_rows > 0) {
            $error_message = 'Nama pengguna atau email sudah digunakan. Silakan coba yang lain.';
        } else {
            // Masukkan data pengguna baru ke database
            $stmt_insert = $conn->prepare("INSERT INTO users (full_name, username, email, password_hash) VALUES (?, ?, ?, ?)");
            $stmt_insert->bind_param("ssss", $full_name, $username, $email, $password_hash);
            
            if ($stmt_insert->execute()) {
                $success_message = "Pendaftaran berhasil! Silakan <a href='login.php'>Masuk</a>.";
                // Reset form fields
                $full_name = $username = $email = '';
            } else {
                $error_message = "Pendaftaran gagal. Coba lagi nanti. Error: " . $conn->error;
            }
            $stmt_insert->close();
        }
        $stmt_check->close();
    }
    $conn->close();
}
?>

<div class="content-wrapper">
    <section class="auth-container register-form-container">
        
        <h2>Daftar Akun Arab Academy</h2>
        
        <?php if (!empty($success_message)): ?>
            <p class="success-msg"><?= $success_message ?></p>
        <?php endif; ?>
        <?php if (!empty($error_message)): ?>
            <p class="error-msg"><?= $error_message ?></p>
        <?php endif; ?>

        <form action="registrasi.php" method="POST" class="register-form">
            
            <div class="form-group">
                <label for="full_name">Nama Lengkap</label>
                <input type="text" id="full_name" name="full_name" required value="<?= htmlspecialchars($full_name) ?>">
            </div>
            
            <div class="form-group">
                <label for="username">Nama Pengguna (Username)</label>
                <input type="text" id="username" name="username" required value="<?= htmlspecialchars($username) ?>">
            </div>
            
            <div class="form-group">
                <label for="email">Alamat Email</label>
                <input type="email" id="email" name="email" required value="<?= htmlspecialchars($email) ?>">
            </div>
            
            <div class="form-group">
                <label for="password">Kata Sandi</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <div class="form-group">
                <label for="confirm_password">Konfirmasi Kata Sandi</label>
                <input type="password" id="confirm_password" name="confirm_password" required>
            </div>
            
            <button type="submit" class="btn-register">Daftar Sekarang</button>
        </form>
        
        <p class="login-link">Sudah punya akun? <a href="login.php">Masuk Sekarang</a></p>
    </section>
</div>

<?php
include 'includes/footer.php';
?>